
//
// To jest przykadowy kod z podrozdziau 23.9 Dopasowywanie przy uyciu wyrae regularnych ksiki
// "Programowanie. Teoria i praktyka z wykorzystaniem C++" Bjarne'a Stroustrupa.
//

#include "std_lib_facilities.h"

//------------------------------------------------------------------------------

int main()
try
{
    ifstream in("table.txt");    // plik wejciowy
    if (!in) error("Brak pliku wejciowego.\n");

    string line;    // bufor wejciowy
    int lineno = 0;

    regex header( "^[\\w ]+(	[\\w ]+)*$"); // wiersz nagwkowy
    regex row( "^[\\w ]+(	\\d+)(	\\d+)(	\\d+)$"); // wiersz danych

    if (getline(in,line)) {       // sprawdza wiersz nagwkowy
        smatch matches;
        if (!regex_search(line, matches, header))
            error("brak nagwka");
    }
    while (getline(in,line)) {    // sprawdza wiersz danych
        ++lineno;
        smatch matches;
        if (!regex_search(line, matches, row)) 
            error("Niepoprawny wiersz.", lineno);
    }
}
catch (std::exception& e) {
    cerr << "Bd: " << e.what() << '\n'; 
    return 1;
}
catch (...) {
    cerr << "Nieznany wyjtek!\n"; 
    return 2;
}

//------------------------------------------------------------------------------
